import sys
from array import array

def solve():
    # Brzo citanje svih brojeva iz ulaza
    def get_input():
        for line in sys.stdin:
            for x in line.replace(',', ' ').split():
                yield int(x)

    input_gen = get_input()
    try:
        n = next(input_gen)
    except StopIteration:
        return

    # Koristimo array umesto liste - troši i do 8x manje memorije
    # 'i' je za signed int (32-bit), dovoljno za vecinu koordinata
    xs = array('i')
    ys = array('i')

    for _ in range(n):
        try:
            xs.append(next(input_gen))
            ys.append(next(input_gen))
        except StopIteration:
            break

    total_greetings = 0

    # Pomocna funkcija za brojanje parova u grupama
    # s = suma svih k_i, s2 = suma kvadrata k_i
    # Broj susreta je (s^2 - s2) // 2
    def count_pairs(keys, multiplier):
        counts = {}
        for k in keys:
            counts[k] = counts.get(k, 0) + 1
        
        current_sum = 0
        for c in counts.values():
            if c > 1:
                current_sum += (c * (c - 1)) // 2
        return current_sum * multiplier

    # 1. Horizontalni (ista y, ista parnost x)
    # Kljuc pravimo kao: y * 2 + (x % 2)
    h_keys = (ys[i] * 2 + (xs[i] % 2) for i in range(len(xs)))
    total_greetings += count_pairs(h_keys, 1)
    del h_keys # Oslobadamo memoriju odmah

    # 2. Vertikalni (ista x, ista parnost y)
    v_keys = (xs[i] * 2 + (ys[i] % 2) for i in range(len(xs)))
    total_greetings += count_pairs(v_keys, 1)
    del v_keys

    # 3. Dijagonala tip 1 (x + y = const)
    d1_keys = (xs[i] + ys[i] for i in range(len(xs)))
    total_greetings += count_pairs(d1_keys, 2)
    del d1_keys

    # 4. Dijagonala tip 2 (y - x = const)
    d2_keys = (ys[i] - xs[i] for i in range(len(xs)))
    total_greetings += count_pairs(d2_keys, 2)
    del d2_keys

    sys.stdout.write(str(total_greetings) + '\n')

if __name__ == "__main__":
    solve()